﻿/*  Author:     Ben Hall
 *  File:       Skill.cs
 *  Date:       4/28/2011
 *  
 *  Purpose:    Skill.cs holds the relevant data needed for Skill objects that are used
 *              in the UseSkill() method.
 *              
 *              It contains values to show if the skill is magical in nature, damaging, healing
 *              or neither, and if it inflicts or removes status effects.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace OnlineGame
{
    public class Skill
    {
        private String skillName;
        private int skillCost;
        private bool magical;
        
        //for damage and healing skills
        private bool damaging;
        private bool healing;
        private int numValue;

        //status effects => Positive numbers cause effect or enhance, negative numbers remove or reduce
        private int poisonEffect;
        private float pDefenseChange;
        private float mDefenseChange;

        private bool isBeneficial;

        public Skill(String nameIn, int costIn, bool isMagicIn, bool damagingIn, bool healingIn, int numValueIn, bool beneficialIn, int poisonEffectIn, float pDefenseModifierIn, float mDefenseModifierIn)
        {
            this.skillName = nameIn;
            this.skillCost = costIn;
            this.magical = isMagicIn;
 
            this.damaging = damagingIn;
            this.healing = healingIn;
            this.numValue = numValueIn;

            this.isBeneficial = beneficialIn;

            this.poisonEffect = poisonEffectIn;
            this.pDefenseChange = pDefenseModifierIn;
            this.mDefenseChange = mDefenseModifierIn;            
        }
 
        public String GetSkillName()
        {
            return this.skillName;
        }

        public int GetSkillCost()
        {
            return this.skillCost;
        }

        public bool IsMagic()
        {
            return this.magical;
        }

        public int GetNumValue()
        {
            return this.numValue;
        }

        public bool IsHealing()
        {
            return this.healing;
        }

        public bool isDamaging()
        {
            return this.damaging;
        }

        public bool IsBeneficial()
        {
            return this.isBeneficial;
        }

        /*  IsUsableOutOfCombat() returns true for any skill that only heals damage or removes
         *  persistent negative status effects
         */
        public bool IsUsableOutOfCombat()
        {
            if (this.isBeneficial == true)
            {
                //if the skill heals or removes poison
                if ((this.healing == true) || (this.poisonEffect < 0))
                {
                    //skill must not damage a target or cause positive status effects
                    if ((this.pDefenseChange == 0) && (this.mDefenseChange == 0) && (this.damaging == false))
                    {
                        return true;
                    }
                }
            }
            return false;
        }
        //STATUS//
        public int GetPoisonEffect()
        {
            return poisonEffect;
        }

        public float GetPDefenseChange()
        {
            return pDefenseChange;
        }

        public float GetMDefenseChange()
        {
            return mDefenseChange;
        }

    }
}
